unit Instructions;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TInstructForm = class(TForm)
    InstructMemo: TRichEdit;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure LoadInstructionsFromResource;
  end;

var
  InstructForm: TInstructForm;

implementation

{$R *.dfm}
{$R Instructions.res}

procedure TInstructForm.LoadInstructionsFromResource;
var
  RS: TResourceStream;
begin
  // Create resource stream
  RS := TResourceStream.CreateFromID(HInstance, 200, RT_RCDATA);
  try
    // Load the rich edit component
    InstructMemo.Lines.LoadFromStream(RS);
  finally
    // Free the stream
    RS.Free;
  end;
end;

procedure TInstructForm.FormCreate(Sender: TObject);
begin
  with InstructForm do
  begin
    Width := Screen.WorkAreaWidth div 2;
    Height := Screen.WorkAreaHeight div 3;
    Left := Screen.WorkAreaWidth div 2 - Width div 2;
    Top := Screen.WorkAreaHeight div 2;
  end;
  LoadInstructionsFromResource;
end;

end.
