unit TargetUnit;

interface

uses Types, Graphics;

type
  TTarget = class
    private
      tX, tY, tTargetColor, tCursorColor, tBackColor,
      tScale: integer;
    public
      procedure Initialize(X, Y, Scale, TargetColor, CursorColor: Integer);
      procedure DrawTarget(Y: Integer; Bitmap: TBitmap);
      procedure DrawCursor(Y: Integer; Bitmap: TBitmap);
      procedure SetScale(Scale: Integer);
    end;

implementation

procedure TTarget.Initialize(X, Y, Scale, TargetColor, CursorColor: Integer);
begin
  tScale := Scale;
  tX := X;
  tY := Y;
  tTargetColor := TargetColor;
  tCursorColor := CursorColor;
end;

procedure TTarget.DrawTarget(Y: Integer; Bitmap: TBitmap);
begin
  tY := Y;
  with Bitmap.Canvas do
  begin
    tBackColor := Brush.Color;
    Pen.Color := tTargetColor;
    Brush.Color := tTargetColor;
    Polygon([Point(tX-60*tScale, tY-5*tScale),
      Point(tX-25*tScale, tY-5*tScale), Point(tX-20*tScale, tY),
      Point(tX-25*tScale, tY+5*tScale), Point(tX-60*tScale, tY+5*tScale)]);
    Polygon([Point(tX+60*tScale, tY-5*tScale),
      Point(tX+25*tScale, tY-5*tScale), Point(tX+20*tScale, tY),
      Point(tX+25*tScale, tY+5*tScale), Point(tX+60*tScale, tY+5*tScale)]);
    Brush.Color := tBackColor;
  end;
end;

procedure TTarget.DrawCursor(Y: Integer; Bitmap: TBitmap);
begin
  tY := Y;
  with Bitmap.Canvas do
  begin
    tBackColor := Brush.Color;
    Pen.Color := tCursorColor;
    Brush.Color := tCursorColor;
    Polygon([Point(tX-20*tScale, tY), Point(tX-15*tScale, tY-5*tScale),
      Point(tX+15*tScale, tY-5*tScale), Point(tX+20*tScale, tY),
      Point(tX+15*tScale, tY+5*tScale), Point(tX-15*tScale, tY+5*tScale)]);
    Brush.Color := tBackColor;
  end;
end;

procedure TTarget.SetScale(Scale: Integer);
begin
  tScale := Scale;
end;

end.